/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.ArrayNodeDiff;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Connector;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Options;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PropertyChangeDiff;
import org.das2.datum.DatumRange;

public class Application
extends DomNode {
    public static final DatumRange DEFAULT_TIME_RANGE = DataSourceUtil.DEFAULT_TIME_RANGE;
    protected CopyOnWriteArrayList<DataSourceFilter> dataSourceFilters = new CopyOnWriteArrayList<DataSourceFilter>(new DataSourceFilter[0]);
    public static final String PROP_DATASOURCEFILTERS = "dataSourceFilters";
    public static final String PROP_PLOT_ELEMENTS = "plotElements";
    protected CopyOnWriteArrayList<PlotElement> plotElements = new CopyOnWriteArrayList();
    public static final String PROP_PLOTS = "plots";
    protected CopyOnWriteArrayList<Plot> plots = new CopyOnWriteArrayList();
    public static final String PROP_CANVASES = "canvases";
    protected CopyOnWriteArrayList<Canvas> canvases = new CopyOnWriteArrayList();
    public static final String PROP_ANNOTATIONS = "annotations";
    protected CopyOnWriteArrayList<Annotation> annotations = new CopyOnWriteArrayList();
    ApplicationController controller;
    protected Options options = new Options();
    protected DatumRange timeRange = DEFAULT_TIME_RANGE;
    public static final String PROP_TIMERANGE = "timeRange";
    private String eventsListUri = "";
    public static final String PROP_EVENTSLISTURI = "eventsListUri";
    public static final String PROP_BINDINGS = "bindings";
    protected CopyOnWriteArrayList<BindingModel> bindings = new CopyOnWriteArrayList();
    public static final String PROP_CONNECTORS = "connectors";
    protected CopyOnWriteArrayList<Connector> connectors = new CopyOnWriteArrayList();

    public DataSourceFilter[] getDataSourceFilters() {
        return this.dataSourceFilters.toArray(new DataSourceFilter[this.dataSourceFilters.size()]);
    }

    public void setDataSourceFilters(DataSourceFilter[] dataSourceFilters) {
        DataSourceFilter[] oldDataSourceFilters = this.dataSourceFilters.toArray(new DataSourceFilter[this.dataSourceFilters.size()]);
        this.dataSourceFilters = new CopyOnWriteArrayList<DataSourceFilter>(dataSourceFilters);
        this.propertyChangeSupport.firePropertyChange(PROP_DATASOURCEFILTERS, oldDataSourceFilters, dataSourceFilters);
    }

    public DataSourceFilter getDataSourceFilters(int index) {
        return this.dataSourceFilters.get(index);
    }

    public void setDataSourceFilters(int index, DataSourceFilter newDataSourceFilter) {
        DataSourceFilter oldDataSourceFilters = this.dataSourceFilters.set(index, newDataSourceFilter);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_DATASOURCEFILTERS, index, oldDataSourceFilters, newDataSourceFilter);
    }

    public PlotElement[] getPlotElements() {
        return this.plotElements.toArray(new PlotElement[this.plotElements.size()]);
    }

    public void setPlotElements(PlotElement[] pele) {
        PlotElement[] old = this.plotElements.toArray(new PlotElement[this.plotElements.size()]);
        this.plotElements = new CopyOnWriteArrayList<PlotElement>(pele);
        this.propertyChangeSupport.firePropertyChange(PROP_PLOT_ELEMENTS, old, pele);
    }

    public PlotElement getPlotElements(int index) {
        return this.plotElements.get(index);
    }

    public void setPlotElements(int index, PlotElement pele) {
        PlotElement old = this.plotElements.set(index, pele);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_PLOT_ELEMENTS, index, old, pele);
    }

    public Plot[] getPlots() {
        return this.plots.toArray(new Plot[this.plots.size()]);
    }

    public void setPlots(Plot[] plots) {
        Plot[] oldPlots = this.plots.toArray(new Plot[this.plots.size()]);
        this.plots = new CopyOnWriteArrayList<Plot>(plots);
        this.propertyChangeSupport.firePropertyChange(PROP_PLOTS, oldPlots, plots);
    }

    public Plot getPlots(int index) {
        return this.plots.get(index);
    }

    public void setPlots(int index, Plot newPlots) {
        Plot oldPlots = this.plots.set(index, newPlots);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_PLOTS, index, oldPlots, newPlots);
    }

    public Canvas[] getCanvases() {
        return this.canvases.toArray(new Canvas[this.canvases.size()]);
    }

    public void setCanvases(Canvas[] canvases) {
        Canvas[] old = this.canvases.toArray(new Canvas[this.canvases.size()]);
        this.canvases = new CopyOnWriteArrayList<Canvas>(canvases);
        this.propertyChangeSupport.firePropertyChange(PROP_CANVASES, old, canvases);
    }

    public Canvas getCanvases(int index) {
        return this.canvases.get(index);
    }

    public void setCanvases(int index, Canvas newCanvas) {
        Canvas old = this.canvases.set(index, newCanvas);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_PLOTS, index, old, newCanvas);
    }

    public Annotation[] getAnnotations() {
        return this.annotations.toArray(new Annotation[this.annotations.size()]);
    }

    public void setAnnotations(Annotation[] annotations) {
        Annotation[] oldAnnotations = this.annotations.toArray(new Annotation[this.annotations.size()]);
        this.annotations = new CopyOnWriteArrayList<Annotation>(annotations);
        this.propertyChangeSupport.firePropertyChange(PROP_ANNOTATIONS, oldAnnotations, annotations);
    }

    public Annotation getAnnotations(int index) {
        return this.annotations.get(index);
    }

    public void setAnnotations(int index, Annotation annotation) {
        Annotation old = this.annotations.set(index, annotation);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_ANNOTATIONS, index, old, annotation);
    }

    public ApplicationController getController() {
        return this.controller;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(DatumRange timeRange) {
        if (timeRange == null) {
            throw new IllegalArgumentException("timeRange set to null");
        }
        if (timeRange.width().value() == 0.0) {
            throw new IllegalArgumentException("timeRange.width().value()==0");
        }
        DatumRange oldTimeRange = this.timeRange;
        this.timeRange = timeRange;
        this.propertyChangeSupport.firePropertyChange(PROP_TIMERANGE, oldTimeRange, timeRange);
    }

    public String getEventsListUri() {
        return this.eventsListUri;
    }

    public void setEventsListUri(String eventsListUri) {
        String oldEventsListUri = this.eventsListUri;
        this.eventsListUri = eventsListUri;
        this.propertyChangeSupport.firePropertyChange(PROP_EVENTSLISTURI, oldEventsListUri, eventsListUri);
    }

    public BindingModel[] getBindings() {
        BindingModel[] result = this.bindings.toArray(new BindingModel[this.bindings.size()]);
        return result;
    }

    public void setBindings(BindingModel[] bindings) {
        BindingModel[] oldBindings = this.getBindings();
        this.bindings = new CopyOnWriteArrayList<BindingModel>(bindings);
        try {
            this.propertyChangeSupport.firePropertyChange(PROP_BINDINGS, oldBindings, bindings);
        }
        catch (NullPointerException ex) {
            try {
                logger.fine("strange case where script creates NullPointerException");
                Thread.sleep(100L);
            }
            catch (InterruptedException ex1) {
                Logger.getLogger(Application.class.getName()).log(Level.SEVERE, null, ex1);
            }
            this.propertyChangeSupport.firePropertyChange(PROP_BINDINGS, oldBindings, bindings);
            logger.log(Level.WARNING, null, ex);
        }
    }

    public BindingModel getBindings(int index) {
        return this.bindings.get(index);
    }

    public void setBindings(int index, BindingModel newBinding) {
        BindingModel oldBinding = this.bindings.set(index, newBinding);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_BINDINGS, index, oldBinding, newBinding);
    }

    public Connector[] getConnectors() {
        Connector[] result = this.connectors.toArray(new Connector[this.connectors.size()]);
        return result;
    }

    public void setConnectors(Connector[] connectors) {
        Connector[] oldConnectors = this.getConnectors();
        this.connectors = new CopyOnWriteArrayList<Connector>(connectors);
        this.propertyChangeSupport.firePropertyChange(PROP_CONNECTORS, oldConnectors, connectors);
    }

    public Connector getConnectors(int index) {
        return this.connectors.get(index);
    }

    public void setConnectors(int index, Connector newConnector) {
        Connector oldConnector = this.connectors.set(index, newConnector);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_CONNECTORS, index, oldConnector, newConnector);
    }

    @Override
    public DomNode copy() {
        Application result = (Application)super.copy();
        result.controller = null;
        result.options = (Options)this.getOptions().copy();
        DataSourceFilter[] DataSourceFiltersCopy = this.getDataSourceFilters();
        for (int i = 0; i < DataSourceFiltersCopy.length; ++i) {
            DataSourceFiltersCopy[i] = (DataSourceFilter)DataSourceFiltersCopy[i].copy();
        }
        result.setDataSourceFilters(DataSourceFiltersCopy);
        Plot[] plotsCopy = this.getPlots();
        for (int i = 0; i < plotsCopy.length; ++i) {
            plotsCopy[i] = (Plot)plotsCopy[i].copy();
        }
        result.setPlots(plotsCopy);
        PlotElement[] peleCopy = this.getPlotElements();
        for (int i = 0; i < peleCopy.length; ++i) {
            peleCopy[i] = (PlotElement)peleCopy[i].copy();
        }
        result.setPlotElements(peleCopy);
        Connector[] connectorsCopy = this.getConnectors();
        for (int i = 0; i < connectorsCopy.length; ++i) {
            connectorsCopy[i] = (Connector)connectorsCopy[i].copy();
        }
        result.setConnectors(connectorsCopy);
        Annotation[] annotationsCopy = this.getAnnotations();
        for (int i = 0; i < annotationsCopy.length; ++i) {
            annotationsCopy[i] = (Annotation)annotationsCopy[i].copy();
        }
        result.setAnnotations(annotationsCopy);
        Canvas[] canvasesCopy = this.getCanvases();
        for (int i = 0; i < canvasesCopy.length; ++i) {
            canvasesCopy[i] = (Canvas)canvasesCopy[i].copy();
        }
        result.setCanvases(canvasesCopy);
        return result;
    }

    @Override
    public List<DomNode> childNodes() {
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        result.addAll(this.plots);
        result.addAll(this.plotElements);
        result.addAll(this.dataSourceFilters);
        result.addAll(this.canvases);
        result.addAll(this.connectors);
        result.addAll(this.annotations);
        result.add(this.options);
        return result;
    }

    @Override
    public void syncTo(DomNode n) {
        this.syncTo(n, new ArrayList<String>());
    }

    @Override
    public void syncTo(DomNode n, List<String> exclude) {
        super.syncTo(n, exclude);
        if (!(n instanceof Application)) {
            throw new IllegalArgumentException("node should be an Application");
        }
        if (this.controller != null) {
            this.controller.syncTo((Application)n, exclude);
        }
    }

    private void addArrayDiffs(String property, Object[] thata, Object[] thisa, List<Diff> result) {
        int i;
        if (thata.length > thisa.length) {
            for (i = thata.length - 1; i >= thisa.length; --i) {
                result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Delete, thata[i], i));
            }
        }
        if (thata.length < thisa.length) {
            for (i = thisa.length - 1; i < thisa.length; ++i) {
                result.add(new ArrayNodeDiff(property, ArrayNodeDiff.Action.Insert, thisa[i], i));
            }
        }
    }

    @Override
    public List<Diff> diffs(DomNode node) {
        int i;
        if (!(node instanceof Application)) {
            throw new IllegalArgumentException("node should be an Application");
        }
        Application that = (Application)node;
        ArrayList<Diff> result = new ArrayList<Diff>();
        this.addArrayDiffs(PROP_DATASOURCEFILTERS, this.getDataSourceFilters(), that.getDataSourceFilters(), result);
        this.addArrayDiffs(PROP_PLOT_ELEMENTS, this.getPlotElements(), that.getPlotElements(), result);
        this.addArrayDiffs(PROP_PLOTS, this.getPlots(), that.getPlots(), result);
        this.addArrayDiffs(PROP_CANVASES, this.getCanvases(), that.getCanvases(), result);
        this.addArrayDiffs(PROP_BINDINGS, this.getBindings(), that.getBindings(), result);
        this.addArrayDiffs(PROP_CONNECTORS, this.getConnectors(), that.getConnectors(), result);
        this.addArrayDiffs(PROP_ANNOTATIONS, this.getAnnotations(), that.getAnnotations(), result);
        for (i = 0; i < Math.min(this.dataSourceFilters.size(), that.dataSourceFilters.size()); ++i) {
            DataSourceFilter thisDataSourceFilter = this.dataSourceFilters.get(i);
            DataSourceFilter thatDataSourceFilter = that.dataSourceFilters.get(i);
            result.addAll(DomUtil.childDiffs("dataSourceFilters[" + i + "]", thatDataSourceFilter.diffs(thisDataSourceFilter)));
        }
        for (i = 0; i < Math.min(this.canvases.size(), that.canvases.size()); ++i) {
            Canvas thisCanvas = this.canvases.get(i);
            Canvas thatCanvas = that.canvases.get(i);
            result.addAll(DomUtil.childDiffs("canvases[" + i + "]", thatCanvas.diffs(thisCanvas)));
        }
        for (i = 0; i < Math.min(this.plots.size(), that.plots.size()); ++i) {
            Plot thisPlot = this.plots.get(i);
            Plot thatPlot = that.plots.get(i);
            result.addAll(DomUtil.childDiffs("plots[" + i + "]", thatPlot.diffs(thisPlot)));
        }
        for (i = 0; i < Math.min(this.connectors.size(), that.connectors.size()); ++i) {
            Connector thisConnector = this.connectors.get(i);
            Connector thatConnector = that.connectors.get(i);
            result.addAll(DomUtil.childDiffs("connectors[" + i + "]", thatConnector.diffs(thisConnector)));
        }
        for (i = 0; i < Math.min(this.annotations.size(), that.annotations.size()); ++i) {
            Annotation thisAnnotation = this.annotations.get(i);
            Annotation thatAnnotation = that.annotations.get(i);
            result.addAll(DomUtil.childDiffs("annotations[" + i + "]", thatAnnotation.diffs(thisAnnotation)));
        }
        for (i = 0; i < Math.min(this.plotElements.size(), that.plotElements.size()); ++i) {
            result.addAll(DomUtil.childDiffs("plotElements[" + i + "]", that.getPlotElements(i).diffs(this.plotElements.get(i))));
        }
        result.addAll(DomUtil.childDiffs("options", this.getOptions().diffs(that.getOptions())));
        if (!that.timeRange.equals((Object)this.timeRange)) {
            result.add(new PropertyChangeDiff(PROP_TIMERANGE, this.timeRange, that.timeRange));
        }
        if (!that.eventsListUri.equals(this.eventsListUri)) {
            result.add(new PropertyChangeDiff(PROP_EVENTSLISTURI, this.eventsListUri, that.eventsListUri));
        }
        return result;
    }

    public DomNode getElementById(String id) {
        DomNode result = DomUtil.getElementById(this, id);
        if (result == null) {
            throw new IllegalArgumentException("unable to find node \"" + id + "\"");
        }
        return result;
    }
}

